#version 330
#extension GL_EXT_gpu_shader4 : enable
//floating in the seaMod01.fsh  by   changwenhan
//https://www.shadertoy.com/view/wtVcR3
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define sin(x) sin(mod(x,radians(360.)))

float rand(vec2 p) {
    p = fract(p * vec2(324.456, 863.789));
    p += dot(p, p+89.56);
    return fract(p.x*p.y);
}

float Wave(vec2 uv, float offset) {
    uv.x += offset;
    
    return (    
                sin(uv.x*48.313 + 312.123) + 
                sin(uv.x*10.) + 
                sin(uv.x*31. + 1.42) +
                sin(uv.x*61.33 + 123.142) +
                sin(uv.x*3.14)
           ) / 5.
           
           *sin(uv.x*3.14*3.1)*1.3;
}


float Moon(vec2 uv, float radius) {
    return step(length(uv), radius);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy-0.5*iResolution.xy)/iResolution.y;
    vec2 moon_uv = uv;
    
    uv.y *= 10.;
    
    vec3 col;
    
    float border = .1;
    
    vec3 line_color = vec3(.8,.8,.8);
    vec3 back_blue = vec3(.3,.4,.8) * .1;
    vec3 back_lightblue = vec3(.3,.4,.8) * .7;
    vec3 yellow = vec3(.9,.9,.5);
    
    float layers = 14.;
    
    for(float i=0.;i<layers/2.3;i+=1.) {
        float offs = (layers/2.-i)*.5 + sin(iTime+i*321.131)*.1;
        float waveOffs = layers/2.-i;
        
        waveOffs += 321.431 + iTime*(i+2.341)*.005 + rand(vec2(123.32,i))*iTime*.1 + rand(vec2(123.32,i))*.4;

        float wave = Wave(uv, waveOffs) * 0.5;
        
        float new_line = step(wave-border*.5, uv.y-offs) - step(wave+border*.5, uv.y-offs);
        float new_line_bottom = 1.-step(wave-border*.5, uv.y-offs);
        
        vec3 back_color = mix(back_lightblue, back_blue, 1.-i/layers);
        
        col = mix(col, line_color, new_line);
        col = mix(col, back_color, new_line_bottom);

    }
    
    col = mix(col, yellow, Moon(moon_uv, .2));
    
    for(float i=layers/2.3;i<layers;i+=1.) {
        float offs = (layers/2.-i)*.5 + sin(iTime+i*321.131)*.1;
        float waveOffs = layers/2.-i;
        
        waveOffs += 321.431 + iTime*(i+2.341)*.005 + rand(vec2(123.32,i))*iTime*.1 + rand(vec2(123.32,i))*.4;

        float wave = Wave(uv, waveOffs) * 0.5;
                
        float new_line_bottom = 1.-step(wave-border*.5, uv.y-offs);
        float new_line = step(wave-border*.5, uv.y-offs) - step(wave+border*.5, uv.y-offs);
        
        
        float moonOffs = Wave(uv.yx, waveOffs)*.3;
        vec2 v = vec2(moon_uv.x + moonOffs*.1, moon_uv.y);
        float moon = Moon(v, .2) * step(uv.y-offs, wave+border*.5);
        
        vec3 back_color = mix(back_lightblue, back_blue, i/layers);
        
        col = mix(col, back_color, new_line_bottom);
        col = mix(col, yellow, moon * (1. - i/layers) * 0.5);
        col = mix(col, line_color, new_line);

    }
    
    vec2 box_size = vec2(.85,.85);
    float box_border = .02;
    
    float box = step(abs(uv.x), box_size.x/2.) * step(abs(uv.y), box_size.y/2. * 10.);
    float smbox = step(abs(uv.x), box_size.x/2.-box_border) * step(abs(uv.y), (box_size.y/2.-box_border) * 10.);
    
    col *= box;
    col = mix(col, line_color, box - smbox);
    col = mix(back_blue*3., col , length(col));    
    
    //if( abs(gl_FragCoord.x-iResolution.x/2.) < 1.) col.g = 1.;
    //if( abs(gl_FragCoord.y-iResolution.y/2.) < 1.) col.r = 1.;
    
    // Output to screen
    gl_FragColor = vec4(vec3(col),1.0);
}